varying vec2 		texcoord;
varying float		dist;
uniform sampler2D 	tex;
uniform vec4		ambientColor;	// ambient  * material color
varying vec4		diffuse;		// diffuse color * material color

// CAUSTICS EFFECT
uniform sampler2D	causticsTex;
/*uniform vec4		LTM0,
					LTM1,
					LTM3;*/
uniform mat4		LTM0;

varying vec4	eyepos;
uniform vec3	sunColor;
varying vec3	worldpos;

// FOG UNIFORMS
uniform vec3  	campos;
uniform vec4 	fogColor;
uniform vec4 	plane;

//varying vec4 	fog;
/////////////////////

#ifdef _HEIGHTMAP_

	uniform sampler2D	cmask;	
	varying vec2 		texcoord2;
	
#endif

// ------------ ATMOSPHERE ------------------------------

//uniform vec2 		earth_center;
uniform vec3 		sundir;

//vec3 GetSunIrradiance(vec3 p, vec3 sun_direction);

// -------------------------------------------------------

float ComputeVolumetricFog( vec3 cameraToWorldPos )
{
	float fogInt;
	fogInt=length( cameraToWorldPos )*0.5;		
	return exp( -fogColor.a/*extintion*/ * (fogInt) );
}

float ComputeScatter( vec3 wpos, vec3 cameraToWorldPos )
{
	float L=0.0;
	float Y=plane.w-campos.y;
	vec3 dir=vec3(0.0,0.0,0.0);
	
	if(Y <= 0.0)
		Y=0.0;
	
	if(wpos.y>plane.w )
		L=(length( cameraToWorldPos ) * Y) / cameraToWorldPos.y; 
	else
		L=length( cameraToWorldPos );
			
	if(L>0.0)
		dir=normalize(cameraToWorldPos);
		
	return exp( -fogColor.a/*extintion*/ * Y * 0.1 ) * ( ( exp((dir.y-1.0)*fogColor.a/*extintion*/*L) - 1.0 ) / ((dir.y-1.0) * fogColor.a/*extintion*/)) * 0.01;
}

void main()
{
	vec4 color=texture2D(tex,texcoord.st);

	#ifdef _HEIGHTMAP_
		
		vec3 one=vec3(1.0,1.0,1.0);
		vec4 maskColor=texture2D(cmask,texcoord2.st);
		maskColor.rgb=pow(maskColor.rgb,vec3(2.2));
		
		vec3 rmul=color.rgb*maskColor.rgb;
		vec3 rscr=one-((one-maskColor.rgb)*(one-color.rgb));
		color.rgb=(color.rgb*rscr+(one-color.rgb)*rmul)*maskColor.a;
		color.a=1.0;

	#endif
	
	// CAUSTICS /////////////////////////////////
	vec4	XYproj;	
	vec3 	projcoords;
	
/*	XYproj.x = dot(eyepos,LTM0);
	XYproj.y = dot(eyepos,LTM1);
	XYproj.w = dot(eyepos,LTM3);*/
	XYproj=LTM0*eyepos;
	
	projcoords.xy=(XYproj.xy/XYproj.w);
	vec2 coords0=projcoords.xy;//*220.0 - ofs;
	
	vec3 c0=texture2D(causticsTex,coords0.xy).rgb;
	vec3 CR=c0*color.xyz*max((1.0-dist*0.0025),0.0);
	
	////////////////////////////////////////////////////
	
	#ifdef _HEIGHTMAP_
		
		vec4 mcolor=texture2D(cmask,texcoord2.st);
		mcolor.rgb=pow(mcolor.rgb,vec3(2.2));
		color*=mcolor;
		
	#endif
	
	// FOG /////////////////////////////
	vec4 fog;
	vec3 viewDir=campos-worldpos.xyz;
	fog.a=ComputeVolumetricFog(-viewDir);
	float scatter=ComputeScatter( worldpos.xyz, -viewDir );
	fog.rgb=fogColor.rgb*scatter;
	/////////////////////////////////// 
	
	/*vec3 rwp=-vec3(0.0,earth_center.x,0.0);
	rwp.y=-earth_center.x+(100.0*earth_center.y);
	vec3 sunLightColor = GetSunIrradiance(rwp, sundir)*sunColor;
	*/
	if(dist<=0.0)
	{
		gl_FragColor.xyz=fog.rgb*0.1*max(sundir.y,0.0);
		gl_FragColor.a=color.a;
	}
	else
	{
		// convert normal to eye space
		gl_FragColor.xyz=(color.xyz*ambientColor.xyz*vec3(0.5) + (color.xyz*diffuse.xyz + CR)*fog.a*sunColor + fog.rgb*0.1)*max(sundir.y,0.0);//mix(fog.rgb,color.xyz*ambientColor.xyz + color.xyz*diffuse.xyz + CR,fog.a);
		gl_FragColor.a=color.a;
	}
}
